//This class:
// - Starts up the communication with the Arduino.
// - Reads the data coming in from the Arduino
// - Converts the data into doubles
// - prints the doubles to terminal 
// - It reads LINES of data coming in
// - prints values out to the frame too
// - there is also a list serial ports function.

//Code builds upon this great example:
//http://www.csc.kth.se/utbildning/kth/kurser/DH2400/interak06/SerialWork.java

//Load Libraries
import java.io.*;
import java.util.TooManyListenersException;
import java.util.Enumeration;

//Load RXTX Library
import gnu.io.*;

class ArduinoComm implements SerialPortEventListener
{

   //Declare serial port variable
   SerialPort mySerialPort;

   //Declare input steam
   InputStream in;
   BufferedReader br;

   OutputStream out;
   BufferedWriter bw;

   String theLine;
   String[] splitArray;

   int value;
   boolean stop=false;
   //Default baudrate
   public int baudRate=115200;


   //This open's the communcations port with the arduino
   public void start(String portName)
   {

      stop=false; 
      try 
      {
         //Finds and opens the port
         CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(portName);
         mySerialPort = (SerialPort)portId.open("my_java_serial" + portName, 2000);
         if (Program.outputStatus==1){System.out.println("Serial port found and opened");}

         //configure the port
         try 
         {
            mySerialPort.setSerialPortParams(baudRate,
            mySerialPort.DATABITS_8,
            mySerialPort.STOPBITS_1,
            mySerialPort.PARITY_NONE);
            if (Program.outputStatus==1){System.out.println("Serial port params set: "+baudRate);}
         } 
         catch (UnsupportedCommOperationException e)
         {
            if (Program.outputStatus==1){System.out.println("Probably an unsupported Speed");}
         }

         //establish stream for reading from the port
         try 
         {
            in  = mySerialPort.getInputStream();
            br = new BufferedReader(new InputStreamReader(in));

            out = mySerialPort.getOutputStream();
            bw = new BufferedWriter(new OutputStreamWriter(out)); 
         } 
         catch (IOException e) 
         { 
            if (Program.outputStatus==1){System.out.println("couldn't get streams");}
         }

         // we could read from "in" in a separate thread, but the API gives us events
         try 
         {
            mySerialPort.addEventListener(this);
            mySerialPort.notifyOnDataAvailable(true);
            if (Program.outputStatus==1){System.out.println("Event listener added");}
         } 
         catch (TooManyListenersException e) 
         {
            if (Program.outputStatus==1){System.out.println("couldn't add listener");}
         }
      }
      catch (Exception e) 
      { 
         if (Program.outputStatus==1){System.out.println("Port in Use: "+e);}
      }
   }

   public void sendCommand(String cmd)
   {
      try 
      {
         
         if (Program.outputStatus==1){System.out.println("Sending: "+cmd+'.');}

         bw.write(cmd+'.');    
         bw.flush();
      }
      catch (Exception e) 
      {
         
         if (Program.outputStatus==1){System.out.println(e);}
      }
   }

   //Used to close the serial port
   public void closeSerialPort() 
   {
      try 
      {
         in.close();
         stop=true; 
         mySerialPort.close();
         
         if (Program.outputStatus==1){System.out.println("Serial port closed");}
      }
      catch (Exception e) 
      {
      if (Program.outputStatus==1){System.out.println(e);}
      
      }
   }

   public void serialEvent(SerialPortEvent event) 
   { 
      //Reads in data while data is available
      while (event.getEventType()== SerialPortEvent.DATA_AVAILABLE && stop==false) 
      {
         try 
         {
            //------------------------------------------------------------------- 
            //Reads in the line
            theLine = br.readLine();
            if (!theLine.startsWith(">",0))
            {

              //Splits the line
              splitArray = theLine.split(" ");
          
              //Converts the individual pieces into doubles and then prints them
              for(int i =0; i < splitArray.length ; i++) 
              {
                  value = Integer.parseInt(splitArray[i]);
                  Program.set[i].addPoint(value);
                  if (Program.outputData==1){System.out.print(value+" ");} //Output data to terminal
              }
          
              if (Program.outputData==1){System.out.println();}              //Output data to terminal

            } else 
            {
                
               if (Program.outputStatus==1){System.out.println(theLine);}
               if (theLine.equals("> end")) 
               {
                  
                  for (int n=0; n<6; n++)
                  {
                     Program.set[n].resetIndex(); 
                  }
                  //myGraph1.xAxisRange(0,set[0].staticIndex);
                  Program.update();  
                  Program.update(); 
               }
            }

            //-------------------------------------------------------------------
         } 
         catch (IOException e) 
         {
            System.out.println(e);
            try 
            {
               //If the serial cable is unplugged this stops the while loop from looping.
               stop=true; 
               if (Program.outputStatus==1){System.out.println("While loop stopped");}
               
               Program.myFrame.canvas.repaint();
            }
            catch (Exception e2) 
            {
               System.out.println(e2);
            }
         }
      }
   }

   //Get a list of serial ports and populate the serial port chooser.
    public void listPorts(){
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL){
              //  System.out.println(portId.getName() + " " +portId.getCurrentOwner());

                //Populate the chooser
                Program.myFrame.availablePorts.addItem(portId.getName());
            }   
        }
    }

}
